﻿$(document).on("pageinit", function () {
    var lang = $("html").attr("lang");
    var formatRegex = /[^A-Za-z]/g;

    var defaultMobiscrollSettings = {
        lang: lang,
        buttons: ["cancel", "clear", "now", "set"],
        circular: true,
        showLabel: true
    }

    $("input[data-datetype='datetime']").each(function () {
        $(this).get(0).type = "text";

        var dateFormat = $(this).attr("data-dateformat");
        var timeFormat = $(this).attr("data-timeformat").replace(/m/g, "i").replace("tt", "A");
        var dateTimeFormat = dateFormat + " " + timeFormat;
        var minValue = getMinimumDateFromDateInput($(this), dateTimeFormat);
        var maxValue = getMaximumDateFromDateInput($(this), dateTimeFormat);

        var options = $.extend(defaultMobiscrollSettings, {
            controls: ["date", "time"],
            dateFormat: dateFormat,
            dateOrder: dateFormat.replace(formatRegex, ""),
            timeFormat: timeFormat,
            timeWheels: timeFormat.replace(formatRegex, ""),
            preset: 'date',
            invalid: getDisabledDates($(this).attr("data-disabled-dates"), dateFormat),
            min: minValue,
            max: maxValue
        });

        mobiscroll.calendar($(this), options);
    });

    $("input[type='date']").each(function () {
        $(this).get(0).type = "text";
        var dateFormat = $(this).attr("data-dateformat");
        var minDate = getMinimumDateFromDateInput($(this), dateFormat);
        var maxDate = getMaximumDateFromDateInput($(this), dateFormat);
        var disabledDates = getDisabledDates($(this).attr("data-disabled-dates"), dateFormat);      

        var options = $.extend(defaultMobiscrollSettings, {
            controls: ["date"],
            dateFormat: dateFormat,
            dateOrder: dateFormat.replace(formatRegex, ""),
            preset: "date",
            invalid: disabledDates,
            min: minDate,
            max: maxDate
        });

        mobiscroll.calendar($(this), options);
    });

    $("input[type='time']").each(function () {
        $(this).get(0).type = "text";

        var timeFormat = $(this).attr("data-timeformat").replace(/m/g, "i").replace("tt", "A");

        var options = $.extend(defaultMobiscrollSettings, {
            controls: ["time"],
            timeFormat: timeFormat
        });

        mobiscroll.calendar($(this), options);
    }); 

    const style = document.createElement('style');
    style.innerHTML = `
        .mbsc-mobiscroll .mbsc-ltr .mbsc-fr-btn-cont {
            text-align: center;
        }
        .mbsc-fr-btn-cont .mbsc-fr-btn-w {
            font-size: 14px;
        }
    `;
    document.head.appendChild(style);
});